/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xbddefs.h
 *       board properties and generic functions
 *
 * This file is included in CAPI and Firmware !!!
 * -----------------------------------------------------------------*/

#ifndef BDDEFS_H_INCLUDED
#define BDDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

#define BX_BOARDPROP_SIZE     13

CLI typedef enum {
  BX_BOARD_RESPECTBIOS,   /* @respectbios  */
  BX_BOARD_BUSCLOCK,      /* @busclock     */
  BX_BOARD_DISPLAY,       /* @display      */
  BX_BOARD_TRIGIO0_MODE,  /* @trigio0mode  */
  BX_BOARD_TRIGIO1_MODE,  /* @trigio1mode  */
  BX_BOARD_TRIGIO2_MODE,  /* @trigio2mode  */
  BX_BOARD_TRIGIO3_MODE,  /* @trigio3mode  */
  BX_BOARD_TRIGIO0_OUT,   /* @trigio0out   */
  BX_BOARD_TRIGIO1_OUT,   /* @trigio1out   */
  BX_BOARD_TRIGIO2_OUT,   /* @trigio2out   */
  BX_BOARD_TRIGIO3_OUT,   /* @trigio3out   */
  BX_BOARD_PCIXCAP,       /* @pcixcap      */
  BX_BOARD_M66EN          /* @m66en        */
} bx_boardtype;

CLI  /* DEF_START ~G_BX_BOARD_BUSSPEED */
#define BX_BOARD_BUSCLOCK_DEF          0 
#define BX_BOARD_BUSCLOCK_SLOW         1 
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_BOARD_DISPLAY */
#define BX_BOARD_DISPLAY_RESERVED 0 
#define BX_BOARD_DISPLAY_USER     1 
#define BX_BOARD_DISPLAY_DEF      2 
#define BX_BOARD_DISPLAY_PERF     3 
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_BOARD_TRIGIO_MODE */
#define BX_BOARD_TRIGIO_MODE_INPONLY     0 /* @inponly */
#define BX_BOARD_TRIGIO_MODE_OPENDRAIN   2 /* @opendrain */
#define BX_BOARD_TRIGIO_MODE_TOTEMPOLE   3 /* @totempole */
CLI  /* DEF_END */

/* CAUTION: DONT EVER CHANGE THE ASSIGNMENT OF THE FOLLOWING OR LOOK
   AT XBOARD.C!!! */
/* (HL, 7-Juli-2000) */
CLI  /* DEF_START ~G_BX_BOARD_TRIGIO_OUT */
#define BX_BOARD_TRIGIO_OUT_TRIGSOURCE  0 /* @trigioouttrigsource */
#define BX_BOARD_TRIGIO_OUT_TRACETRIG   1 /* @trigioouttracetrig */
#define BX_BOARD_TRIGIO_OUT_DATACOMP    2 /* @trigiooutdatacmp */
#define BX_BOARD_TRIGIO_OUT_PROTERR     3 /* @trigiooutproterr */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_BOARD_PCIXCAP */
#define BX_BOARD_PCIXCAP_PCI       0   
#define BX_BOARD_PCIXCAP_PCIX66    1
#define BX_BOARD_PCIXCAP_PCIX133   2
#define BX_BOARD_PCIXCAP_PCIX266   3
#define BX_BOARD_PCIXCAP_PCIX533   4
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_BOARD_M66EN */
#define BX_BOARD_M66EN_GND         0 
#define BX_BOARD_M66EN_OPEN        1 
CLI  /* DEF_END */

#define BX_STATUSPROP_SIZE 62

CLI typedef enum {
  BX_STAT_CMP_FAIL,               /* @fail         */
  BX_STAT_CMP_CMD,                /* @cmd          */
  BX_STAT_CMP_ADDR_HI,            /* @addrhi       */
  BX_STAT_CMP_ADDR_LO,            /* @addrlo       */
  BX_STAT_CMP_EXTCMD,             /* @extcmd       */
  BX_STAT_CMP_ATTR_LO,            /* @attrlo       */
  BX_STAT_CMP_ACTUAL_HI,          /* @acthi        */
  BX_STAT_CMP_ACTUAL_LO,          /* @actlo        */
  BX_STAT_CMP_REF_HI,             /* @refhi        */
  BX_STAT_CMP_REF_LO,             /* @reflo        */
  BX_STAT_CMP_DATAPHASE,          /* @dataphase    */
  BX_STAT_CMP_DATASUBPHASE,       /* @datasubphase */
  BX_STAT_CMP_BEATTR,             /* @beattr       */
  BX_STAT_CMP_BEDATA,             /* @bedata       */
  BX_STAT_CMP_XFERSIZE,           /* @xfersize     */
  BX_STAT_CMP_ICMP,               /* @icmp         */
  BX_STAT_CMP_TCMP,               /* @tcmp         */
  BX_STAT_CMP_RESOURCE,           /* @resource     */
  BX_STAT_ERR_PERR,               /* @perr         */
  BX_STAT_ERR_SERR,               /* @serr         */
  BX_STAT_ERR_WRPAR,              /* @wrpar        */
  BX_STAT_ERR_WRPAR64,            /* @wrpar64      */
  BX_STAT_INTA,                   /* @inta         */
  BX_STAT_INTB,                   /* @intb         */
  BX_STAT_INTC,                   /* @intc         */
  BX_STAT_INTD,                   /* @intd         */
  BX_STAT_OBS_ERR,                /* @obserr       */
  BX_STAT_TRC_RUNNING,            /* @running      */
  BX_STAT_TRC_TRIGGER,            /* @trigger      */
  BX_STAT_TRC_MEMFULL,            /* @memfull      */
  BX_STAT_TRC_TRIGPOS,            /* @trigpos      */
  BX_STAT_TRC_LINES,              /* @lines        */
  BX_STAT_PCIXPOWER,              /* @pcixpower    */
  BX_STAT_PCIXMODE,               /* @pcixmode     */
  BX_STAT_PCIRESET,               /* @pcireset     */
  BX_STAT_RESETCODE,              /* @resetcode    */
  BX_STAT_LASTRESET,              /* @lastreset    */
  BX_STAT_BUSSPEED,               /* @busspeed     */
  BX_STAT_PLLSPEED,               /* @pllspeed     */
  BX_STAT_BUSWIDTH,               /* @buswidth     */
  BX_STAT_PIGGYBACKID,            /* @piggybackid  */
  BX_STAT_TRIGIO,                 /* @trigio       */
  BX_STAT_INVISIBLE,              /* @invisible    */
  BX_STAT_USRSETT,                /* @usrsett      */
  BX_STAT_STDRECOVR,              /* @stdrecovr    */
  BX_STAT_IABORT,                 /* @iabort       */
  BX_STAT_TABORT,                 /* @tabort       */
  BX_STAT_TEST,                   /* @test         */
  BX_STAT_CFGSTAT,                /* @cfgstat      */
  BX_STAT_CLK,                    /* @clk          */
  BX_STAT_SPLITFAIL,              /* @splitfail    */
  BX_STAT_DIAG_FPGATEMP,          /* @fpgatemp     */
  BX_STAT_DIAG_BOARDTEMP,         /* @boardtemp    */
  BX_STAT_DIAG_V5,                /* @v5           */
  BX_STAT_DIAG_V12,               /* @v12          */
  BX_STAT_DIAG_VIO,               /* @vio          */
  BX_STAT_DIAG_VCC,               /* @vcc          */
  BX_STAT_DIAG_VCORE,             /* @vcore        */
  BX_STAT_DIAG_VCCP2,             /* @vccp2        */
  BX_STAT_DIAG_VBOARD,            /* @vboard       */
  BX_STAT_DIAG_STATUS,            /* @status       */
  BX_STAT_DIAG_FANSPEED           /* @fanspeed     */
} bx_statustype;

CLI  /* DEF_START ~G_BX_STAT_TEST */
#define BX_STAT_TEST_STOPPED        0x1
#define BX_STAT_TEST_WAITING        0x2
#define BX_STAT_TEST_RUNNING        0x4
#define BX_STAT_TEST_DONE           0x20
#define BX_STAT_TEST_COMPLETION     0x40
#define BX_STAT_TEST_IABORT         0x80
#define BX_STAT_TEST_TABORT         0x100 
#define BX_STAT_TEST_TAGBUSY        0x200       /* not documented */ 
#define BX_STAT_TEST_CIPIPEFULL     0x400       /* not documented */
#define BX_STAT_TEST_RUNSTOP        0x800       /* not documented */
#define BX_STAT_TEST_BREAK          0x1000      /* not documented */
#define BX_STAT_TEST_CLEAR          0x2000      /* not documented */
#define BX_STAT_TEST_INDONE         0x4000      /* not documented */
#define BX_STAT_TEST_UNKNOWN        0x20000000  /* not documented */
#define BX_STAT_TEST_RESERVED30     0x40000000  /* not documented */
#define BX_STAT_TEST_RESERVED31     0x80000000  /* not documented */
CLI /* DEF_END */

/* For Compatibility to 1.0.7.0 and previous versions */
#define BX_STAT_TEST_CONDSTART BX_STAT_TEST_WAITING

/* DBI clock speed in Hz for frequency measurement in CAPI and FW */
#define BX_DBIFREQ  32000000

/* Maximum allowed busspeed for decoder speed A */
#define BX_MAXBUSSPEED_FOR_DECSPEED_A 67000000

/* --------------------------------------------------------------------------
 * Pattern terms
 * -------------------------------------------------------------------------- */

CLI typedef enum {
  BX_PATT_BUS0,                /* @bus0     */
  BX_PATT_BUS1,                /* @bus1     */
  BX_PATT_COND0,               /* @cond0    */
  BX_PATT_COND1,               /* @cond1    */
  BX_PATT_BUS2,                /* @bus2     */
  BX_PATT_BUS3,                /* @bus3     */
  BX_PATT_OBS0,                /* @obs0     */
  BX_PATT_OBS1,                /* @obs1     */
  BX_PATT_OBS2,                /* @obs2     */
  BX_PATT_OBS3,                /* @obs3     */
  BX_PATT_OBS4,                /* @obs4     */
  BX_PATT_OBS5,                /* @obs5     */
  BX_PATT_ERR0,                /* @err0     */
  BX_PATT_TRAN0,               /* @tran0    */
  BX_PATT_ENUMSIZE             /* $enumsize */
} bx_patttype;

#endif


